###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mmc MDVA-2010:044 (mmc)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830850);
  script_version("$Revision: 6589 $: 1.0");
  script_xref(name: "MDVA", value: "2010:044");
  script_name("Mandriva Update for mmc MDVA-2010:044 (mmc)");
  desc = "

  Vulnerability Insight:

  This is a bundle of MDS related packages that fixes numerous bugs.
  
  mmc-agent:
  * Fix password injection in LDIF file when running adduser hook
  * Set default value of shadowExpire to -1 to avoid account expiration
  messages
  * Fix bad peer reported by the connection debug message
  * Fix provisioning when authenticating using the local LDAP
  * Support for RFC3062 extended password change operation
  * The MDVA-2009:216 update caused regressions that is now fixed
  (#55912):
  * use %%py_puresitedir instead of %%py_platsitedir (misc)
  * remove arch dependant references
  
  mmc-web-base:
  * fix MMC login page with regards to the connect button and the
  language select widget
  * Update to scriptaculous V 1.8.3 (correct some problems when using
  with IE)
  * Ask web browser not to autocomplete input fields #52654
  * Fix password update bug #52654
  * New icons needed for Pulse 2
  
  mmc-web-network:
  * French translation update #52936
  * Spanish translation update
  
  mmc-web-samba:
  * French translation update #52936
  
  mmc-wizard:
  * fixes a typo error in mds.ini: shadowExpore instead of shadowExpire
  in [userDefault] (#57249).

  Affected Software/OS:
  mmc on Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00081.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mmc");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"mmc-agent", rpm:"mmc-agent~2.3.2~0.5mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mmc-web-base", rpm:"mmc-web-base~2.3.2~0.3mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mmc-web-network", rpm:"mmc-web-network~2.3.2~0.3mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mmc-web-samba", rpm:"mmc-web-samba~2.3.2~0.3mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mmc-wizard", rpm:"mmc-wizard~1.0~13.4mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-mmc-base", rpm:"python-mmc-base~2.3.2~0.5mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-mmc-mail", rpm:"python-mmc-mail~2.3.2~0.5mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-mmc-network", rpm:"python-mmc-network~2.3.2~0.5mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-mmc-proxy", rpm:"python-mmc-proxy~2.3.2~0.5mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-mmc-samba", rpm:"python-mmc-samba~2.3.2~0.5mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}