###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for virt-manager MDVA-2010:055 (virt-manager)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830864);
  script_version("$Revision: 6743 $: 1.0");
  script_xref(name: "MDVA", value: "2010:055");
  script_name("Mandriva Update for virt-manager MDVA-2010:055 (virt-manager)");
  desc = "

  Vulnerability Insight:

  This advisory updates virt-manager to 0.8 version, fixing many bugs
  and adding new useful functionalities. Therefore, libvirt was also
  upgraded to a more recent version.
  
  Additionally, python-virtinst was updated to include Mandriva Linux
  in OS list for virt-manager, and dnsmasq was updated to not start
  service by default to prevent conflict with virt-manager.

  Affected Software/OS:
  virt-manager on Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-02/msg00012.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of virt-manager");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"dnsmasq", rpm:"dnsmasq~2.45~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvirt0", rpm:"libvirt0~0.7.6~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvirt-devel", rpm:"libvirt-devel~0.7.6~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvirt-static-devel", rpm:"libvirt-static-devel~0.7.6~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvirt-utils", rpm:"libvirt-utils~0.7.6~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-libvirt", rpm:"python-libvirt~0.7.6~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-virtinst", rpm:"python-virtinst~0.500.1~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"virt-manager", rpm:"virt-manager~0.8.2~1.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvirt", rpm:"libvirt~0.7.6~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64virt0", rpm:"lib64virt0~0.7.6~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64virt-devel", rpm:"lib64virt-devel~0.7.6~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64virt-static-devel", rpm:"lib64virt-static-devel~0.7.6~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}