###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for glibc MDVA-2010:081 (glibc)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830913);
  script_version("$Revision: 6863 $: 1.0");
  script_xref(name: "MDVA", value: "2010:081");
  script_name("Mandriva Update for glibc MDVA-2010:081 (glibc)");
  desc = "

  Vulnerability Insight:

  glibc 2.10.1 on Mandriva 2010.0 can't resolve names with some buggy
  routers. This update includes upstream fixes post glibc 2.10.1 release
  that fixes the issue (Mandriva bug #57698). Other glibc resolver fixes
  are included too, which addresses also some other upstream opened bugs.

  Affected Software/OS:
  glibc on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-02/msg00059.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of glibc");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"glibc", rpm:"glibc~2.10.1~6.4mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-devel", rpm:"glibc-devel~2.10.1~6.4mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-doc", rpm:"glibc-doc~2.10.1~6.4mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-doc-pdf", rpm:"glibc-doc-pdf~2.10.1~6.4mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-i18ndata", rpm:"glibc-i18ndata~2.10.1~6.4mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-profile", rpm:"glibc-profile~2.10.1~6.4mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-static-devel", rpm:"glibc-static-devel~2.10.1~6.4mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-utils", rpm:"glibc-utils~2.10.1~6.4mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nscd", rpm:"nscd~2.10.1~6.4mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}