###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for rsnapshot MDVA-2010:088 (rsnapshot)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830939);
  script_version("$Revision: 6957 $: 1.0");
  script_xref(name: "MDVA", value: "2010:088");
  script_name("Mandriva Update for rsnapshot MDVA-2010:088 (rsnapshot)");
  desc = "

  Vulnerability Insight:

  Rsnapshot will automatically add --exclude=xxxx to the rsync
  options for backups of the filesystem on which the snapshot-root
  is located. This will be added to the rsync command-line AFTER the
  rsync_short_args and rsync_long_args, but BEFORE any backup-specific
  options. This means that the --exclude=xxxx will override whatever
  backup-specific excludes are defined. This can be a problem if the
  name of your snapshot-root is something which is common in many file
  names. This version resolves this problems.

  Affected Software/OS:
  rsnapshot on Mandriva Linux 2009.1,
  Mandriva Linux 2009.1/X86_64,
  Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-03/msg00003.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of rsnapshot");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"rsnapshot", rpm:"rsnapshot~1.3.1~5.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.1")
{

  if(isrpmvuln(pkg:"rsnapshot", rpm:"rsnapshot~1.3.1~4.2mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}