###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for foomatic-db MDVA-2010:099 (foomatic-db)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830942);
  script_version("$Revision: 6957 $: 1.0");
  script_xref(name: "MDVA", value: "2010:099");
  script_name("Mandriva Update for foomatic-db MDVA-2010:099 (foomatic-db)");
  desc = "

  Vulnerability Insight:

  There was a regression in certain versions of foomatic-rip 3 and 4,
  which has since been fixed. As a result, old versions fail the LSB
  printing tests.
  
  This advisory updates foomatic-db to 4.0 that passes the LSB tests
  and also provides various updated printing softwares and drivers.

  Affected Software/OS:
  foomatic-db on Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-03/msg00024.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of foomatic-db");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"cups-drivers-foo2zjs", rpm:"cups-drivers-foo2zjs~0.0~0.20090122.2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-drivers-lbp660", rpm:"cups-drivers-lbp660~0.3.1~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-drivers-splix", rpm:"cups-drivers-splix~2.0.0~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"foomatic-db", rpm:"foomatic-db~4.0~0.20090316.0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"foomatic-db-engine", rpm:"foomatic-db-engine~4.0.1~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"foomatic-db-hpijs-20090208", rpm:"foomatic-db-hpijs-20090208~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"foomatic-filters", rpm:"foomatic-filters~4.0.1~1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gutenprint-common", rpm:"gutenprint-common~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gutenprint-cups", rpm:"gutenprint-cups~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gutenprint-escputil", rpm:"gutenprint-escputil~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gutenprint-foomatic", rpm:"gutenprint-foomatic~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gutenprint-gimp2", rpm:"gutenprint-gimp2~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gutenprint-ijs", rpm:"gutenprint-ijs~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-doc", rpm:"hplip-doc~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-gui", rpm:"hplip-gui~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs", rpm:"hplip-hpijs~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs-ppds", rpm:"hplip-hpijs-ppds~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-model-data", rpm:"hplip-model-data~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgutenprint2", rpm:"libgutenprint2~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgutenprint2-devel", rpm:"libgutenprint2-devel~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgutenprintui2_1", rpm:"libgutenprintui2_1~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgutenprintui2_1-devel", rpm:"libgutenprintui2_1-devel~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0", rpm:"libhpip0~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0-devel", rpm:"libhpip0-devel~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpython2.5", rpm:"libpython2.5~2.5.2~5.6mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpython2.5-devel", rpm:"libpython2.5-devel~2.5.2~5.6mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsane-hpaio1", rpm:"libsane-hpaio1~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mtink", rpm:"mtink~1.0.14~14.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python", rpm:"python~2.5.2~5.6mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-base", rpm:"python-base~2.5.2~5.6mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-docs", rpm:"python-docs~2.5.2~5.6mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"system-config-printer", rpm:"system-config-printer~1.0.16~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"system-config-printer-libs", rpm:"system-config-printer-libs~1.0.16~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"task-printing", rpm:"task-printing~2009.0~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"task-printing-canon", rpm:"task-printing-canon~2009.0~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"task-printing-epson", rpm:"task-printing-epson~2009.0~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"task-printing-hp", rpm:"task-printing-hp~2009.0~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"task-printing-lexmark", rpm:"task-printing-lexmark~2009.0~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"task-printing-misc", rpm:"task-printing-misc~2009.0~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"task-printing-okidata", rpm:"task-printing-okidata~2009.0~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"task-printing-scanning", rpm:"task-printing-scanning~2009.0~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"task-printing-server", rpm:"task-printing-server~2009.0~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter", rpm:"tkinter~2.5.2~5.6mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter-apps", rpm:"tkinter-apps~2.5.2~5.6mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gutenprint", rpm:"gutenprint~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gutenprint2", rpm:"lib64gutenprint2~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gutenprint2-devel", rpm:"lib64gutenprint2-devel~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gutenprintui2_1", rpm:"lib64gutenprintui2_1~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gutenprintui2_1-devel", rpm:"lib64gutenprintui2_1-devel~5.2.3~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0", rpm:"lib64hpip0~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0-devel", rpm:"lib64hpip0-devel~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64python2.5", rpm:"lib64python2.5~2.5.2~5.6mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64python2.5-devel", rpm:"lib64python2.5-devel~2.5.2~5.6mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64sane-hpaio1", rpm:"lib64sane-hpaio1~3.9.2~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}