###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_maxthon_javascript_n_data_uri_xss_vuln.nasl 4376 2009-09-07 22:04:26Z sep $
#
# Maxthon 'javascript:' And 'data:' URI XSS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800897);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3018");
  script_name("Maxthon 'javascript:' And 'data:' URI XSS Vulnerability");
  desc = "
  Overview: This host is installed with Maxthon Browser and is prone to
  Cross-Site Scripting vulnerability.

  Vulnerability Insight:
  Error occurs when application fails to sanitise the 'javascript:' and 'data:'
  URIs in Refresh headers or Location headers in HTTP responses, which can be
  exploited via vectors related to injecting a Refresh header or Location HTTP
  response header.

  Impact:
  Successful exploitation will let the attackers to conduct Cross-Site Scripting
  attacks in the victim's system.

  Impact Level: Application

  Affected Software/OS:
  Maxthon version 3.0.0.145 on Windows.

  Fix:
  No solution or patch is available as on 05th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.maxthon.com/index.htm

  References:
  http://websecurity.com.ua/3386/
  http://www.securityfocus.com/archive/1/archive/1/506163/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Maxthon");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_maxthon_detect.nasl");
  script_require_keys("Maxthon/Ver");
  exit(0);
}


include("version_func.inc");

# Get for Maxthon Browser
maxthonVer = get_kb_item("Maxthon/Ver");

if(maxthonVer)
{
  # Check for Maxthon Browser Version 3.0.0.145
  if(version_is_equal(version:maxthonVer, test_version:"3.0.0.145")){
    security_warning(0);
  }
}
