###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mdpro_sql_inj_vuln.nasl 3687 2009-08-06 10:4033Z aug $
#
# MDPro Surveys Module SQL Injection Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800919);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2618");
  script_bugtraq_id(35495);
  script_name("MDPro Surveys Module SQL Injection Vulnerability");
  desc = "

  Overview: This host is installed with MDPro and is prone to SQL Injection
  vulnerability.

  Vulnerability Insight:
  The Surveys module fails to validate the user supplied data passed into
  the 'pollID' parameter before using it in an SQL query.

  Impact:
  This flaw can be exploited via malicious SQL commands to modify or delete
  information in the back-end database.

  Impact Level: Application

  Affected Software/OS:
  MDPro version 1.083.x

  Fix: No solution or patch is available as on 06th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.maxdev.com/

  References:
  http://www.milw0rm.com/exploits/9021
  http://xforce.iss.net/xforce/xfdb/51385

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of MDPro");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_mdpro_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

mdproPort = get_http_port(default:80);
if(!mdproPort){
  exit(0);
}

mdproVer = get_kb_item("www/" + mdproPort + "/MDPro");
mdproVer = eregmatch(pattern:"^(.+) under (/.*)$", string:mdproVer);

if(mdproVer[1] =~ "^1\.083"){
  security_hole(mdproPort);
}
