###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_memcachedb_info_disclosure_vuln.nasl 2114 2009-05-14 13:45:29Z may $
#
# MemcacheDB Information Disclosure Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800717);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1255");
  script_bugtraq_id(34756);
  script_name("MemcacheDB Information Disclosure Vulnerability");
  desc = "

  Overview: The host is running MemcacheDB and is prone to Information Disclosure
  Vulnerabilities.

  Vulnerability Insight:
  Error in process_stat function discloses the contents of /proc/self/maps in
  response to a stats maps command.

  Impact:
  Successful exploitation will let the attacker craft execute malicious commands
  and pass it to the vulnerable functions to gain sensitive information about the
  application.

  Affected Software/OS:
  MemcacheDB version 1.2.0 and prior

  Fix: No solution or patch is available as on 18th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://memcachedb.org

  Workaround:
  Apply the workaround.
  http://www.positronsecurity.com/advisories/2009-001.html

  References:
  http://secunia.com/advisories/34932
  http://www.vupen.com/english/advisories/2009/1197

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 4.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of MemcacheDB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_memcachedb_detect.nasl");
  script_require_keys("MemCacheDB/Ver");
  exit(0);
}


include("version_func.inc");

memcachedbVer = get_kb_item("MemCacheDB/Ver");
if(memcachedbVer == NULL){
  exit(0);
}

# Grep for MemcacheDB version 1.2.0 and prior
if(version_is_less_equal(version:memcachedbVer, test_version:"1.2.0")){
  security_warning(memdbPort);
}
