###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_merak_mail_server_mult_vuln.nasl 2157 2009-05-09 10:42:13Z may $
#
# IceWarp Merak Mail Server Multiple Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800388);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1467", "CVE-2009-1468", "CVE-2009-1469");
  script_bugtraq_id(34823, 34820, 34827, 34825);
  script_name("IceWarp Merak Mail Server Multiple Vulnerabilities");
  desc = "

  Overview: The host is running Merak Mail Server and is prone to Cross-Site
  Script vulnerabilities.

  Vulnerability:
  - Error in cleanHTML function in server/inc/tools.php is related to the email
    view and incorrect processing of HTML filtering.
  - Error in getHTML function in server/inc/rss/item.php is related to title,
    link, or description element in an RSS feed.
  - Error exists in search form in server/webmail.php in the Groupware component
    via 'sql' and 'order_by' elements in an XML search query.
  - Error occur in Forgot Password implementation in server/webmail.php via CRLF
    sequences preceding a Reply-To header in the subject element of an XML
    document.

  Impact:
  Successful attacks will let the attackers to inject arbitrary web script or
  HTML script code via a specially crafted email in a user's browser session
  in the context of an affected site.

  Impact Level: Application

  Affected Software/OS:
  Merak Mail Server prior to 9.4.2

  Fix: Upgrade to Merak Mail Server 9.4.2
  http://www.icewarp.com

  References:
  http://www.vupen.com/english/advisories/2009/1253
  http://www.redteam-pentesting.de/advisories/rt-sa-2009-001
  http://www.redteam-pentesting.de/advisories/rt-sa-2009-002
  http://www.redteam-pentesting.de/advisories/rt-sa-2009-003
  http://www.redteam-pentesting.de/advisories/rt-sa-2009-004

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Merak Mail Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_merak_mail_server_detect.nasl");
  script_require_keys("MerakMailServer/Ver");
  exit(0);
}


include("version_func.inc");

merakVer = get_kb_item("MerakMailServer/Ver");
if(!merakVer){
  exit(0);
}

if(version_is_less(version:merakVer, test_version:"9.4.2")){
  security_warning(0);
}
