###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_moinmoin_wiki_detect.nasl 7492 2010-02-05 17:50:35Z mar $
#
# MoinMoin Wiki Version Detection
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800170);
  script_version("$Revision: 6915 $: 1.0");
  script_name("MoinMoin Wiki Version Detection");
  desc = "
  Overview : This script detects the installed version of MoinMoin Wiki
  and sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set version of MoinMoin Wiki in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

## Get MoinMoin Wiki port
moinWikiPort = get_http_port(default:80);
if(!moinWikiPort){
  moinWikiPort = 80;
}

## Check Port status
if(!get_port_state(moinWikiPort)){
  exit(0);
}

foreach path (make_list("/", "/moin", "/wiki", cgi_dirs()))
{
  ## Send the request and Recieve the response
  sndReq = http_get(item: path + "/SystemInfo", port:moinWikiPort);
  rcvRes = http_send_recv(port:moinWikiPort, data:sndReq);

  ## Check for MoinMoin and SystemInfo in the response
  if("SystemInfo" >< rcvRes && ">MoinMoin " >< rcvRes )
  {
    ## Get MoinMoin Wiki Version
    moinWikiVer = eregmatch(pattern:"Release ([0-9.a-z]+) \[Revision release\]",
                            string:rcvRes);
    if(moinWikiVer[1] != NULL)
    {
      set_kb_item(name:"www/" + moinWikiPort + "/moinmoinWiki",
                        value:moinWikiVer[1] + " under " + path);
      exit(0);
    }
  }
}
