###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_moinmoin_wiki_user_prof_unspecified_vuln.nasl 7492 2010-03-05 15:24:29Z mar $
#
# MoinMoin Wiki User Profile Unspecified Vulnerability
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800172);
  script_version("$Revision: 6915 $: 1.0");
  script_bugtraq_id(38023);
  script_cve_id("CVE-2010-0669");
  script_name("MoinMoin Wiki User Profile Unspecified Vulnerability");
  desc = "
  Overview: This host is running MoinMoin Wiki and is prone to unspecified
  vulnerability.

  Vulnerability Insight:
  An unspecified error exists in MoinMoin Wiki related to sanitization of
  user profiles.

  Impact:
  Impact is currently unknown.

  Impact Level: Application

  Affected Software/OS:
  MoinMoin Wiki version before 1.8.7 and 1.9 before 1.9.2 on all platforms.

  Fix: Upgrade to MoinMoin Wiki 1.8.7 or 1.9.2,
  For updates refer, http://moinmo.in/MoinMoinDownload

  References:
  http://moinmo.in/SecurityFixes
  http://secunia.com/advisories/38444
  http://www.openwall.com/lists/oss-security/2010/02/21/2
  http://www.openwall.com/lists/oss-security/2010/02/15/2

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of MoinMoin Wiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_moinmoin_wiki_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

## Get the port where MoinMoin Wiki application is running
moinWikiPort = get_http_port(default:80);
if(!moinWikiPort){
  exit(0);
}

## Get MoinMoin Wiki Version from KB
moinWikiVer = get_kb_item("www/" + moinWikiPort + "/moinmoinWiki");
moinWikiVer = eregmatch(pattern:"^(.+) under (/.*)$", string:moinWikiVer);

if(moinWikiVer[1] != NULL)
{
  ## Check for version before 1.8.7 or 1.9 before 1.9.2
  if(version_is_less(version:moinWikiVer[1], test_version:"1.8.7") ||
     version_in_range(version:moinWikiVer[1], test_version:"1.9",
                                             test_version2:"1.9.1")){
    security_hole(moinWikiPort);
  }
}
