###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mozilla_detect_lin.nasl 4411 2009-09-04 19:23:29Z sep $
#
# Mozilla Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800884);
  script_version("$Revision: 1.0 $");
  script_name("Mozilla Version Detection (Linux)");
  desc = "
  Overview: This script is detects the installed version of Mozilla Browser
  and sets the result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Mozilla Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

mozilla_sock = ssh_login_or_reuse_connection();
if(!mozilla_sock){
  exit(0);
}

mozillaName = find_file(file_name:"mozilla", file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:mozilla_sock);

foreach binary_name (mozillaName)
{
  binary_name = chomp(binary_name);
  mozillaVer = get_bin_version(full_prog_name:binary_name, sock:mozilla_sock,
                               version_argv:"-v", ver_pattern:"Mozilla " +
                               "([0-9]\.[0-9.]+)(.*build ([0-9]+))?");
  if(!isnull(mozillaVer[1]))
  {
    set_kb_item(name:"Mozilla/Linux/Ver", value:mozillaVer[1]);
    if(!isnull(mozillaVer[3]))
    {
      ver = mozillaVer[1] + "." + mozillaVer[3];
      set_kb_item(name:"Mozilla/Build/Linux/Ver", value:ver);
    }
  }
}
ssh_close_connection();
