###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mozilla_prdts_dos_vuln_jul09_lin.nasl 3573 2009-07-21 18:05:33Z jul $
#
# Mozilla Products 'select()' Denial Of Service Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800849);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2535", "CVE-2009-1692");
  script_bugtraq_id(35446);
  script_name("Mozilla Products 'select()' Denial Of Service Vulnerability (Linux)");
  desc = "

  Overview:
  The host is installed with Mozilla Firefox/Seamonkey/Thunderbird and is prone
  to Denial of Service vulnerability.

  Vulnerability Insight:
  A null pointer dereference error occurs while calling the 'select' method
  with a large integer, that results in continuous allocation of x+n bytes of
  memory, exhausting memory after a while.

  Impact:
  Successful exploitation will let attackers to cause application crash by
  consuming the memory.

  Impact Level: Application

  Affected Software/OS:
  Seamonkey version prior to 1.1.17
  Thunderbird version 2.0.0.22 and prior
  Firefox version before 2.0.0.19 and 3.x before 3.0.5 on Linux.

  Fix:
  Upgrade to Firefox version 2.0.0.19 or 3.0.5 or later
  http://www.mozilla.com/en-US/firefox/all.html
  Upgrade to Seamonkey version 1.1.17 or later
  http://www.seamonkey-project.org/releases/
  Apply patch for Thunderbird through above mozilla engine update
  http://www.mozillamessaging.com/

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://www.milw0rm.com/exploits/9160
  http://www.g-sec.lu/one-bug-to-rule-them-all.html

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 5.6
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Mozilla Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_lin.nasl", "gb_seamonkey_detect_lin.nasl",
                      "gb_thunderbird_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver", "Seamonkey/Linux/Ver",
                      "Thunderbird/Linux/Ver");
  exit(0);
}


include("version_func.inc");

# Firefox Check
ffVer = get_kb_item("Firefox/Linux/Ver");
if(ffVer)
{
  # Grep for Firefox version < 2.0.0.19 and < 3.0.5
  if(version_is_less(version:ffVer, test_version:"2.0.0.19")||
     version_in_range(version:ffVer, test_version:"3.0", test_version2:"3.0.4"))
  {
    security_hole(0);
    exit(0);
  }
}

# Seamonkey Check
smVer = get_kb_item("Seamonkey/Linux/Ver");
if(smVer != NULL)
{
  # Grep for Seamonkey version < 1.1.17
  if(version_is_less(version:smVer, test_version:"1.1.17"))
  {
    security_hole(0);
    exit(0);
  }
}

# Thunderbird Check
tbVer = get_kb_item("Thunderbird/Linux/Ver");
if(tbVer != NULL)
{
  # Grep for Thunderbird version <= 2.0.0.22
  if(version_is_less_equal(version:tbVer, test_version:"2.0.0.22")){
    security_hole(0);
  }
}
