###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mozilla_prdts_necko_dns_info_disc_vuln_win.nasl 7065 2010-02-03 11:06:33Z feb $
#
# Mozilla Products Necko DNS Information Disclosure Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800455);
  script_version("$Revision$: 1.0");
  script_cve_id("CVE-2009-4629");
  script_name("Mozilla Products Necko DNS Information Disclosure Vulnerability (Win)");
  desc = "
  Overview: The host is installed with Thundebird/Seamonkey and is prone to
  Information Disclosure vulnerability.

  Vulnerability Insight:
  The flaw exists while DNS prefetching, when the app type is 'APP_TYPE_MAIL'
  or 'APP_TYPE_EDITOR'

  Impact:
  Successful exploitation will let the attackes obtain the network location of
  the applications user by logging DNS requests.

  Impact Level: Application

  Affected Software/OS:
  Mozilla Thunderbird version 3.0.1 and
  Seamonkey with Mozilla Necko version 1.9.0 and prior on Windows.

  Fix:  Apply the patch or Upgrade to  Mozilla Necko version 1.9.1
  http://www.mozilla.com/en-US/products/
  https://bug492196.bugzilla.mozilla.org/attachment.cgi?id=377824

  *****
  NOTE: Ignore this warning, if above mentioned patch is already applied.
  *****

  References:
  https://bugzilla.mozilla.org/show_bug.cgi?id=492196
  https://secure.grepular.com/DNS_Prefetch_Exposure_on_Thunderbird_and_Webmail

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 3.7
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Firefox/Seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_seamonkey_detect_win.nasl", "gb_thunderbird_detect_win.nasl");
  script_require_keys("Thunderbird/Win/Ver", "Seamonkey/Win/Ver");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

# Seamonkey Check
smVer = get_kb_item("Seamonkey/Win/Ver");
if(!isnullsmVer)
{

  path = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                            "\App Paths\seamonkey.exe", item:"path");
  path = path + "\seamonkey.exe";

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",  string:path);

  seaVer = GetVer(file:file, share:share);
  if(!isnull(seaVer))
  {
    if(version_is_less(version:seaVer, test_version:"1.9.1"))
    {
      security_warning(0);
      exit(0);
    }
  }
}

# Thunderbird Check
fpVer = get_kb_item("Thunderbird/Win/Ver");
if(!isnull(fpVer))
{
  if(version_is_less_equal(version:fpVer, test_version:"3.0.1")){
    security_warning(0);
  }
}

