###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_clickjacking_vuln.nasl 930 2009-02-03 16:11:24Z feb $
#
# Microsoft Internet Explorer Clickjacking Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800347);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0369");
  script_name("Microsoft Internet Explorer Clickjacking Vulnerability");
  desc = "

  Overview: This host has installed Internet Explorer and is prone to
  clickjacking vulnerability

  Vulnerability Insight:
  Attackers will trick users into visiting an arbitrary URL via an onclick
  action that moves a crafted element to the current mouse position.

  Impact:
  Successful exploitation could allow remote attackers to execute arbitrary
  code and can retrieve sensitive information from the affected application.

  Impact Level: System

  Affected Software/OS:
  Windows Internet Explorer version 7.x on Windows.

  Fix: No solution or patch is available as on 04th February, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,
  http://www.microsoft.com/windows/internet-explorer/download-ie.aspx

  References:
  http://www.milw0rm.com/exploits/7912
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2009-0369

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


# Check for Internet Explorer version 7.x
if(get_kb_item("MS/IE/Version") =~ "^7\..*"){
  security_warning(0);
}
