###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_dep_remote_code_exec_vuln.nasl 6821 2010-01-18 12:40:05Z jan $
#
# Microsoft Internet Explorer Remote Code Execution Vulnerability (979352)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800429);
  script_version("$Revision: 6460 $: 1.0");
  script_cve_id("CVE-2010-0249");
  script_bugtraq_id(37815);
  script_name("Microsoft Internet Explorer Remote Code Execution Vulnerability (979352)");
  desc = "
  Overview:
  The host is installed with Internet Explorer and is prone to Remote Code
  Execution vulnerability.

  Vulnerability Insight:
  An invalid pointer reference error exists under certain conditions letting an
  invalid pointer to be accessed after an object is deleted.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary code
  via specially crafted attack.

  Impact Level: Application

  Affected Software/OS:
  Internet Explorer Version 6.x, 7.x , 8.x

  Fix: Apply the patch,
  http://support.microsoft.com/kb/979352

  Workaround:
  Apply workaround as in the advisory.

  *****
  NOTE: Ignore this warning if you are using IE 8 on Windows XP SP3 because
        IE 8 opts-in to DEP by default.
  *****

  References:
  http://support.microsoft.com/kb/979352
  http://www.microsoft.com/technet/security/advisory/979352.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

ieVer = get_kb_item("MS/IE/Version");
if(isnull(ieVer)){
  exit(0);
}

# Checking For the workaround
if(registry_key_exists(key:"SOFTWARE\Microsoft\Windows NT\CurrentVersion" +
                            "\AppCompatFlags\Custom\iexplore.exe")){
  exit(0);
}

#Checking for version
if(ieVer =~ "^[6|7|8]\."){
    security_hole(0);
}
