###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_dos_vuln_jul09.nasl 3575 2009-07-21 12:40:05Z jul $
#
# Microsoft Internet Explorer Denial Of Service Vulnerability - July09
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800669);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2536", "CVE-2009-1692");
  script_bugtraq_id(35446);
  script_name("Microsoft Internet Explorer Denial Of Service Vulnerability - July09");
  desc = "

  Overview:
  The host is installed with Internet Explorer and is prone to Denial Of
  Service vulnerability.

  Vulnerability Insight:
  Error exists while calling the select method with a large integer, that
  results in continuos allocation of x+n bytes of memory exhausting memory
  after a while.

  Impact:
  Successful exploitation will let the attacker to cause a denial of service
  by exhausting memory.

  Impact Level: Application

  Affected Software/OS:
  Internet Explorer Version 5.x, 6.x, 7.x and 8.x

  Fix: No solution or patch is available as on 21st July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/downloads/ie/getitnow.mspx

  References:
  http://www.milw0rm.com/exploits/9160
  http://www.g-sec.lu/one-bug-to-rule-them-all.html
  http://www.securityfocus.com/archive/1/archive/1/504969/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");

# Check for Internet Explorer version 5.0 to 8.0.6001.18702
if(version_in_range(version:ieVer, test_version:"5.0",
                                   test_version2:"8.0.6001.18702")){
  security_warning(0);
}
