###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_ssl_certi_sec_bypass_vuln_oct09.nasl 5091 2009-10-05 21:51:26Z oct $
#
# Microsoft IE CA SSL Certificate Security Bypass Vulnerability - Oct09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801109);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3454");
  script_bugtraq_id(36475);
  script_name("Microsoft IE CA SSL Certificate Security Bypass Vulnerability - Oct09");
  desc = "
  Overview: This host is installed with Internet Explorer and is prone to
  Security Bypass vulnerability.

  Vulnerability Insight:
  Microsoft Internet Explorer fails to properly validate '\0' character in the
  domain name in a signed CA certificate, allowing attackers to substitute
  malicious SSL certificates for trusted ones.

  Impact:
  Successful exploitation will let the attackers to perform man-in-the-middle
  attacks or impersonate trusted servers, which will aid in further attack.

  Impact Level: Application

  Affected Software/OS:
  Microsoft IE version 6.x/7.x/8.x

  Fix: No solution or patch is available as on 05th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.google.com/chrome

  References:
  http://www.wired.com/threatlevel/2009/07/kaminsky/
  http://www.networkworld.com/news/2009/073009-more-holes-found-in-webs.html
  http://www.networkworld.com/news/2009/091709-microsoft-ie-security-hole.html

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");
if(isnull(ieVer)){
  exit(0);
}

# Check for IE version 6.x or 7.x or 8.x
if(ieVer =~ "^(6|7|8)\..*"){
  security_hole(0);
}
