###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_sharepoint_xss_vuln.nasl 7494 2010-03-03 15:47:24Z mar $
#
# Microsoft SharePoint Cross Site Scripting Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800481);
  script_version("$Revision: 6915 $: 1.0");
  script_cve_id("CVE-2010-0716");
  script_name("Microsoft SharePoint Cross Site Scripting Vulnerability");
  desc = "
  Overview: This host is running Microsoft SharePoint Server and is prone to
  Cross Site Scripting vulnerability.

  Vulnerability Insight:
  This flaw is caused due to insufficient validation of user supplied data
  passed into 'SourceUrl' and 'Source' parameters in the 'download.aspx' in
  SharePoint Team Services.

  Impact:
  Successful exploitation will allow remote authenticated users to leverage
  same-origin relationships and conduct cross-site scripting attacks by
  uploading TXT files.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Office SharePoint Server 2007 12.0.0.6421 and prior.

  Fix:
  No solution or patch is available as on 03rd March, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sharepoint.microsoft.com/Pages/Default.aspx

  References:
  http://www.hacktics.com/content/advisories/AdvMS20100222.html
  http://www.securityfocus.com/archive/1/archive/1/509683/100/0/threaded

  CVSS Score:
    CVSS Base Score      : 3.5 (AV:N/AC:M/Au:SI/C:N/I:P/A:N)
    CVSS Temporal Score  : 3.1
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of MS SharePoint Team Services");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Windows");
  script_dependencies("remote-detect-WindowsSharepointServices.nasl");
  script_require_keys("MicrosoftSharePointTeamServices/version");
  exit(0);
}


include("version_func.inc");

stsVer = get_kb_item("MicrosoftSharePointTeamServices/version");
if(isnull(stsVer)){
  exit(0);
}

if(version_in_range(version:stsVer, test_version:"12.0", test_version2:"12.0.0.6421")){
  security_warning(0);
}
