###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_win_mp_int_overflow_vuln.nasl 793 2009-01-02 10:43:24Z jan $
#
# Integer Overflow vulnerability in Microsoft Windows Media Player
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800328);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5745");
  script_bugtraq_id(33042);
  script_name("Integer Overflow vulnerability in Microsoft Windows Media Player");
  desc = "

  Overview: This host has Windows Media Player installed and is prone to
  Integer Overflow vulnerability

  Vulnerability Insight:
  The issue is caused due to improper loading of WAV, SND or MID files on
  the affected application.

  Impact:
  Successful exploitation will allow attackers to execute arbitrary codes
  and cause application crash.

  Impact Level: Application

  Affected Software/OS:
  Microsoft, Windows Media Player version 9.x, 10.x, and 11.x

  Fix: No solution or patch is available as on 05th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/

  References:
  http://securitytracker.com/alerts/2008/Dec/1021495.html
  http://downloads.securityfocus.com/vulnerabilities/exploits/33042.c

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Windows Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_ms_win_media_player_detect_900173.nasl");
  exit(0);
}


#Grep for the versions 9.x , 10.x and 11.x
if(get_kb_item("Win/MediaPlayer/Ver") =~ "^(9|1[01])\..*$"){
  security_warning(0);
}
