###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mysql_auth_bypass_vuln_lin.nasl 5988 2009-12-03 23:29:17Z dec $
#
# MySQL Authenticated Access Restrictions Bypass Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801065);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7247");
  script_name("MySQL Authenticated Access Restrictions Bypass Vulnerability (Linux)");
  desc = "
  Overview: The host is running MySQL and is prone to Access Restrictions Bypass
  Vulnerability

  Vulnerability Insight:
  The flaw is due to an error in 'sql/sql_table.cc', when the data home directory
  contains a symlink to a different filesystem.

  Impact:
  Successful exploitation could allow users to bypass intended access restrictions
  by calling CREATE TABLE with  DATA DIRECTORY or INDEX DIRECTORY argument referring
  to a subdirectory.

  Impact Level: Application

  Affected Software/OS:
  MySQL 5.0.x before 5.0.88, 5.1.x before 5.1.41, 6.0 before 6.0.9-alpha

  Fix: Upgrade to MySQL version 5.0.88 or 5.1.41 or 6.0.9-alpha
  For Updates Refer, http://dev.mysql.com/downloads

  References:
  http://lists.mysql.com/commits/59711
  http://bugs.mysql.com/bug.php?id=39277
  http://marc.info/?l=oss-security&m=125908040022018&w=2

  CVSS Score:
    CVSS Base Score      : 6.0 (AV:N/AC:M/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score  : 4.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of MySQL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("mysql_version.nasl");
  script_require_ports("Services/mysql", 3306);
  exit(0);
}


include("misc_func.inc");
include("version_func.inc");

sqlPort = get_kb_item("Services/mysql");
if(!sqlPort){
  sqlPort = 3306;
}

if(!get_port_state(sqlPort)){
  exit(0);
}

mysqlVer = get_mysql_version(port:sqlPort);
if(isnull(mysqlVer)){
  exit(0);
}

mysqlVer = eregmatch(pattern:"([0-9.a-z]+)", string:mysqlVer);
if(isnull(mysqlVer[1])){
  exit(0);
}

if(version_in_range(version:mysqlVer[1], test_version:"5.0",test_version2:"5.0.87") ||
   version_in_range(version:mysqlVer[1], test_version:"5.1",test_version2:"5.1.40")){
  security_warning(sqlPort);
}

else if(mysqlVer[1] =~ "^6\.")
{
  if(version_is_less(version:mysqlVer[1],test_version:"6.0.9a")){
    security_warning(sqlPort);
  }
}
