###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mysql_mult_format_string_vuln.nasl 3418 2009-07-16 21:29:17Z jul $
#
# MySQL 'sql_parse.cc' Multiple Format String Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800842);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2446");
  script_bugtraq_id(35609);
  script_name("MySQL 'sql_parse.cc' Multiple Format String Vulnerabilities");
  desc = "

  Overview: The host is running MySQL and is prone to Multiple Format String
  vulnerabilities.

  Vulnerability Insight:
  The flaws are due to error in the 'dispatch_command' function in sql_parse.cc
  in libmysqld/ which can caused via format string specifiers in a database name
  in a 'COM_CREATE_DB' or 'COM_DROP_DB' request.

  Impact:
  Successful exploitation could allow remote authenticated users to cause a Denial
  of Service and possibly have unspecified other attacks.

  Impact Level: Application

  Affected Software/OS:
  MySQL version 4.0.0 to 5.0.83 on all running platform.

  Fix: Upgrade to MySQL version 5.1.36 or later
  http://dev.mysql.com/downloads

  References:
  http://www.osvdb.org/55734
  http://secunia.com/advisories/35767
  http://xforce.iss.net/xforce/xfdb/51614
  http://www.securityfocus.com/archive/1/archive/1/504799/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 8.5 (AV:N/AC:M/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of MySQL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("mysql_version.nasl");
  script_require_ports("Services/mysql", 3306);
  exit(0);
}


include("misc_func.inc");
include("version_func.inc");

sqlPort = get_kb_item("Services/mysql");
if(!sqlPort){
  sqlPort = 3306;
}

if(!get_port_state(sqlPort)){
  exit(0);
}

mysqlVer = get_mysql_version(port:sqlPort);
if(mysqlVer != NULL)
{
  if(version_in_range(version:mysqlVer, test_version:"4.0",
                                        test_version2:"5.0.83")){
    security_hole(sqlPort);
  }
}
