###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openfire_detect.nasl 1003 2009-02-10 18:34:24Z feb $
#
# OpenFire Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800353);
  script_version("Revision: 1.0 ");
  script_name("OpenFire Version Detection");
  desc = "
  Overview : This script detects the installed version of OpenFire and
  sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the version of OpenFire");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 9090);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

# Check for default port 9090
firePort = get_http_port(default:9090);
if(!firePort){
  firePort = 9090;
}

if(get_port_state(firePort))
{
  sndReq = string("GET /login.jsp:", "\r\n",
                  "Host: ", get_host_name(), ":", firePort , "\r\n");
  rcvRes = http_keepalive_send_recv(port:firePort, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if("Openfire Admin Console" >< rcvRes)
  {
    fireVer = eregmatch(pattern:"Openfire, Version: ([0-9.]+)", string:rcvRes);
    if(fireVer[1] != NULL)
    {
      set_kb_item(name:"www/" + firePort + "/Openfire", value:fireVer[1]);
      exit(0);
    }
  }
}
