###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openoffice_mult_code_exec_vuln_win_feb10.nasl 7303 2010-02-17 12:26:47 feb $
#
# OpenOffice Multiple Remote Code Execution Vulnerabilities - Feb10
#
# Authors:
# Veerendra G <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800167);
  script_version("$Revision: 6788 $: 1.0");
  script_bugtraq_id(38218);
  script_cve_id("CVE-2009-2949", "CVE-2009-2950", "CVE-2009-3301", "CVE-2009-3302");
  script_name("OpenOffice Multiple Remote Code Execution Vulnerabilities - Feb10");
  desc = "
  Overview: This host has OpenOffice running which is prone to multiple
  remote code execution vulnerabilities.

  Vulnerability Insight:
  - GIF Files in GIFLZWDecompressor:: GIFLZWDecompressor function in
    filter.vcl/lgif/decode.cxx leading to heap overflow.
  - XPM files in XPMReader::ReadXPM function in filter.vcl/ixpm/svt_xpmread.cxx
    leading to an integer overflow.
  - Microsoft Word document in filter/ww8/ww8par2.cxx leading to application
    crash or execute arbitrary code via crafted sprmTSetBrc table property
    in a Word document.

  Impact:
  Successful exploitation lets the attackers to cause a denial of service
  or execute arbitrary code.

  Impact Level: Application/System

  Affected Software/OS:
  OpenOffice.org versions prior to 3.2

  Fix:
  Upgrade to OpenOffice.org version 3.2 or later,
  http://download.openoffice.org/index.html

  References:
  http://secunia.com/advisories/38568
  http://xforce.iss.net/xforce/xfdb/56236
  http://xforce.iss.net/xforce/xfdb/56238
  http://xforce.iss.net/xforce/xfdb/56240
  http://xforce.iss.net/xforce/xfdb/56241
  http://www.vupen.com/english/advisories/2010/0366

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_openoffice_detect_win.nasl");
  script_require_keys("OpenOffice/Win/Ver");
  exit(0);
}


include("version_func.inc");

## Get the OpenOffice Version from the KB
openOffVer = get_kb_item("OpenOffice/Win/Ver");
if(!openOffVer){
  exit(0);
}

if(openOffVer != NULL)
{
  ## Check for OpenOffice Verion 3.2
  if(version_is_less(version:openOffVer, test_version:"3.2")){
    security_hole(0);
  }
}
