###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openoffice_vba_macro_sett_sec_bypass_vuln.nasl 7303 2010-02-17 15:26:47 feb $
#
# OpenOffice VBA Macro Restrictions Remote Security Bypass Vulnerability
#
# Authors:
# Veerendra G <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800168);
  script_version("$Revision: 6790 $: 1.0");
  script_bugtraq_id(38245);
  script_cve_id("CVE-2010-0136");
  script_name("OpenOffice VBA Macro Restrictions Remote Security Bypass Vulnerability");
  desc = "
  Overview: This host has OpenOffice running which is prone to remote
  security bypass vulnerability.

  Vulnerability Insight:
  The flaw exists while handling Visual Basic Applications(VBA) macros
  security settings. When a specially crafted document is opened, attacker
  will be able to execute a VBA macro with the ability to bypass macro
  security settings.

  Impact:
  Successful exploitation lets the attackers to execute a VBA macro
  bypassing security settings.

  Impact Level: Application

  Affected Software/OS:
  OpenOffice.org versions 2.0.4, 2.4.1, and 3.1.1

  Fix:
  Upgrade to OpenOffice.org version 3.2 or later,
  http://download.openoffice.org/index.html

  References:
  http://securitytracker.com/alerts/2010/Feb/1023588.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("secpod_openoffice_detect_win.nasl");
  script_require_keys("OpenOffice/Win/Ver");
  exit(0);
}


include("version_func.inc");

## Get OPenOffice Version from the KB
openOffVer = get_kb_item("OpenOffice/Win/Ver");
if(!openOffVer){
  exit(0);
}

if(openOffVer  =~ "^(2|3)\..*")
{
  ## Check OPenOffice Version 2.0.4, 2.4.1 (2.4.9310) and 3.1.1 (3.1.9420)
  if(version_in_range(version:openOffVer, test_version:"2.0", test_version2:"2.0.4") ||
     version_in_range(version:openOffVer, test_version:"2.4", test_version2:"2.4.9310") ||
     version_in_range(version:openOffVer, test_version:"3.1", test_version2:"3.1.9420")) {
    security_warning(0);
  }
}
