###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_dos_vuln_nov09_lin.nasl 5566 2009-11-02 17:01:26Z nov $
#
# Opera Denial Of Service Vulnerability - Nov09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801141);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3831");
  script_bugtraq_id(36850);
  script_name("Opera Denial Of Service Vulnerability - Nov09 (Linux)");
  desc = "
  Overview: This host is installed with Opera Web Browser and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  An error when processing domain names can be exploited to cause a memory
  corruption.

  Impact:
  Successful attackes may leads to Denial of Service on the affected application.

  Impact Level: Application

  Affected Software/OS:
  Opera version prior to 10.01 on Linux.

  Fix: Upgrade to Opera version 10.01 or later
  http://www.opera.com/browser/download/

  References:
  http://secunia.com/advisories/37182
  http://www.opera.com/support/kb/view/938/
  http://www.opera.com/docs/changelogs/unix/1001/
  http://www.vupen.com/english/advisories/2009/3073

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_opera_detection_linux_900037.nasl");
  script_require_keys("Opera/Linux/Version");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Linux/Version");
if(operaVer)
{
  # Check for Opera Version < 10.01
  if(version_is_less(version:operaVer, test_version:"10.01")){
    security_hole(0);
  }
}
