###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_info_disc_n_code_exec_win.nasl 386 2008-10-29 14:47:50Z oct $
#
# Opera Remote Code Execution and Information Disclosure Vulnerabilities (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800046);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4694", "CVE-2008-4695");
  script_name("Opera Remote Code Execution and Information Disclosure Vulnerabilities (Win)");
  desc = "

  Overview: The host is installed with Opera Web Browser and is prone to
  remote code execution and information disclosure Vulnerabilities.

  Vulnerability Insight:
  Flaws are due to,
  - an error in Opera.dll, that fails to anchor identifier (optional argument)
  - an unknown error in predicting the cache pathname of a cached Java
    applet and then launching this applet from the cache.

  Impact: Successful remote attack could inject arbitrary code, launch
  cross site attacks, information disclosure and can even steal related DB
  (DataBase) contents.

  Impact Level: Application

  Affected Software/OS:
  Opera version prior to 9.60 on Windows.

  Fix: Upgrade to Opera 9.60 or later
  http://www.opera.com/download/

  References:
  http://www.opera.com/support/search/view/901/
  http://www.opera.com/support/search/view/902/

  CVSS Score:
    CVSS Base Score     : 8.8 (AV:N/AC:M/Au:NR/C:C/I:C/A:N)
    CVSS Temporal Score : 6.5
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Win/Version");
if(!operaVer){
  exit(0);
}

if(version_is_less(version:operaVer, test_version:"9.60")){
  security_hole(0);
}
