###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_mult_vuln_oct08_lin.nasl 386 2008-10-29 18:35:35Z oct $
#
# Opera Web Browser Multiple XSS Vulnerability (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800045);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4696", "CVE-2008-4697",
                "CVE-2008-4698", "CVE-2008-4725");
  script_bugtraq_id(31842, 31869);
  script_name("Opera Web Browser Multiple XSS Vulnerability (Linux)");
  desc = "

  Overview: The host is installed with Opera Web Browser and is prone to
  multiple Cross Site Scripting (XSS) Vulnerability.

  Vulnerability Insight:
  Flaws are due to,
  - the URL of visited pages are not properly sanitised by the History Search
    functionality before being used.
  - an error in the implementation of the Fast Forward feature.
  - an error while blocking scripts during a news feed preview.

  Impact: Successful remote attack could inject arbitrary code, launch
  cross site attacks, information disclosure and can even steal related DB
  (DataBase) contents.

  Impact Level: Application

  Affected Software/OS:
  Opera version prior to 9.61 on Linux.

  Fix: Upgrade to Opera 9.61
  http://www.opera.com/download/

  References:
  http://www.opera.com/support/search/view/903/
  http://www.opera.com/support/search/view/904/
  http://www.opera.com/support/search/view/905/

  CVSS Score:
    CVSS Base Score     : 8.8 (AV:N/AC:M/Au:NR/C:C/I:C/A:N)
    CVSS Temporal Score : 6.5
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_opera_detection_linux_900037.nasl");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Linux/Version");
if(!operaVer){
  exit(0);
}

if(version_is_less(version:operaVer, test_version:"9.61")){
  security_hole(0);
}
