###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_outreach_project_tool_detect.nasl 5959 2009-12-05 16:25:36Z dec $
#
# Outreach Project Tool Version Detection (OPT)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801069);
  script_version("Revision: 1.0 ");
  script_name("Outreach Project Tool Version Detection (OPT)");
  desc = "
  Overview: This script finds the installed Outreach Project Tool version and
  saves the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of Outreach Project Tool(OPT) in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

optPort = get_http_port(default:80);
if(!optPort){
  exit(0);
}

foreach path(make_list("/", "/OPT127MAX/opt", "/opt", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php?OPT_Session=" +
                                      " OpenVAS_Req"), port:optPort);
  rcvRes = http_send_recv(port:optPort, data:sndReq);
  if("<title>Outreach Project Tool Login</title>" >< rcvRes)
  {
    sndReq = http_get(item:string(path, "/include/init_OPT_lib.txt"), port:optPort);
    rcvRes = http_send_recv(port:optPort, data:sndReq);
    if(!isnull(rcvRes) && (optVer = egrep(pattern:"CRM_ver.*", string:rcvRes)))
    {
      optVer = eregmatch(pattern:"([0-9.]+)", string:optVer);
      if(optVer[1] != NULL){
       set_kb_item(name:"www/" + optPort + "/OPT", value:optVer[1] + " under " + path);
      }
    }
  }
}
