###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_perl_utf8_regex_dos_vuln_win.nasl 5569 2009-11-04 13:33:41Z nov $
#
# Perl UTF-8 Regular Expression Processing DoS Vulnerability (Windows)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800967);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3626");
  script_bugtraq_id(36812);
  script_name("Perl UTF-8 Regular Expression Processing DoS Vulnerability (Windows)");
  desc = "
  Overview: The host is installed with Perl and is prone to Denial of Service
  Vulnerability.

  Vulnerability Insight:
  An error occurs in Perl while matching an utf-8 character with large or
  invalid codepoint with a particular regular expression.

  Impact:
  Attackers can exploit this issue to crash an affected application via
  specially crafted UTF-8 data leading to Denial of Service.

  Impact Level: Application

  Affected Software/OS:
  Perl version 5.10.1 on Windows.

  Fix: Apply the patch.
  http://perl5.git.perl.org/perl.git/commit/0abd0d78a73da1c4d13b1c700526b7e5d03b32d4

  *****
  NOTE: Ignore this warning if the above mentioned patch is already applied.
  *****

  References:
  http://xforce.iss.net/xforce/xfdb/53939
  http://www.openwall.com/lists/oss-security/2009/10/23/8
  https://issues.apache.org/SpamAssassin/show_bug.cgi?id=6225

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Perl");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_perl_detect_win.nasl");
  script_require_keys("Strawberry/Perl/Ver", "ActivePerl/Ver");
  exit(0);
}


include("version_func.inc");

apVer = get_kb_item("ActivePerl/Ver");
if(!isnull(apVer) && version_is_equal(version:apVer, test_version:"5.10.1"))
{
  security_warning(0);
  exit(0);
}

spVer = get_kb_item("Strawberry/Perl/Ver");
if(!isnull(spVer) && version_is_equal(version:spVer, test_version:"5.10.1")){
  security_warning(0);
}
