###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_pgp_desktop_dos_vuln.nasl 789 2009-01-02 13:40:29Z jan $
#
# PGP Desktop Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800216);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5731");
  script_bugtraq_id(32991);
  script_name("PGP Desktop Denial of Service Vulnerability");
  desc = "

  Overview: This host is running PGP Desktop and is prone to Denial of Service
  Vulnerability.

  Vulnerability Insight:
  This flaw is due to an error in the PGPwded.sys device driver when handling
  certain METHOD_BUFFERED IOCTL request that overwrites portions of memory.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary codes in
  the context of an application via crafted program to cause denial of service.

  Affected Software/OS:
  PGP Corporation, PGP Desktop version 9.9.0.397 or prior on Windows.

  Fix: No solution or patch is available as on 05th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.pgp.com/products/desktop/index.html

  References:
  http://secunia.com/advisories/33310
  http://www.milw0rm.com/exploits/7556

  CVSS Score:
    CVSS Base Score     : 2.1 (AV:L/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 1.9
  Risk factor: Low";

  script_description(desc);
  script_summary("Check for the version of PGP Desktop");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_pgp_desktop_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

ver = get_kb_item("PGPDesktop/Win/Ver");
if(!ver){
  exit(0);
}

# Grep for version 9.9.0.397 and prior
if(version_is_less_equal(version:ver, test_version:"9.9.0.397")){
  security_warning(0);
}
