###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpnagios_detect.nasl 6881 2010-01-21 16:25:36Z jan $
#
# phpNagios Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
#This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800437);
  script_version("$Revision: 6483 $:1.0");
  script_cve_id("CVE-2009-4626");
  script_name("phpNagios Version Detection");
  desc = "
  Overview: This script finds the running phpNagios version and saves
  the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of phpNagios in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

pnPort = get_http_port(default:80);
if(!pnPort){
  exit(0);
}

foreach path (make_list("/", "/phpNagios", "/phpnagios", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:pnPort);
  rcvRes = http_send_recv(port:pnPort, data:sndReq);
  if("phpNagios" >< rcvRes)
  {
    Ver= eregmatch(pattern:"Nagios Version : ([0-9.]+)",string:rcvRes);
    if(!isnull(Ver[1])){
      set_kb_item(name:"www/" + pnPort + "/phpNagios", value:Ver[1] + " under " + path);
    }
  }
}
