###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpnagios_lfi_vuln.nasl 6881 2010-01-21 15:11:27Z jan $
#
# phpNagios 'conf[lang]' Parameter Local File Inclusion Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800438);
  script_version("$Revision: 6483 $: 1.0");
  script_cve_id("CVE-2009-4626");
  script_name("phpNagios 'conf[lang]' Parameter Local File Inclusion Vulnerability");
  desc = "
  Overview: The host is running phpNagios and is prone to local file include
  Vulnerabilities.

  Vulnerability Insight:
  The flaw is caused due to error in 'menu.php' and is not properly sanitising
  user supplied input data via 'conf[lang]' parameter.

  Impact:
  Successful exploitation could allow remote attackers to obtain sensitive
  information or execute arbitrary code on the vulnerable web server.

  Impact Level: Application.

  Affected Software/OS:
  phpNagios version 1.2.0 and prior.

  Fix: No solution or patch is available as on 21st January, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/phpnagios/

  References:
  http://www.milw0rm.com/exploits/9611
  http://xforce.iss.net/xforce/xfdb/53119
  http://www.vupen.com/english/advisories/2009/2615

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 6.7
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of phpNagios");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_dependencies("gb_phpnagios_detect.nasl");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

pnPort = get_http_port(default:80);
if(!pnPort){
  exit(0);
}

pnVer = get_kb_item("www/" + pnPort + "/phpNagios");

pnVer = eregmatch(pattern:"^(.+) under (/.*)$", string:pnVer);
if(!isnull(pnVer[1]))
{
  # phpNagios version 1.2.0 (3.0)
  if(version_is_less_equal(version:pnVer[1], test_version:"3.0")){
    security_hole(pnPort);
  }
}

