###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_serenity_player_detect.nasl 5966 2009-12-07 21:47:29Z dec $
#
# Serenity/Mplay Player Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800728);
  script_version("$Revision: 1.0 $");
  script_name("Serenity/Mplay Player Version Detection");
  desc = "
  Overview: This script detects the installed version of Serenity/Mplay
  Audio Player and sets the reuslt in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Serenity/Mplay Audio Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

function find_version(path, file)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:file);
  serenityVer = GetVer(file:file, share:share);
  return serenityVer;
}

appKey  = "SOFTWARE\Serenity Audio Player";
appKey2 = "SOFTWARE\Malx media player";
if(!registry_key_exists(key:appKey) && !registry_key_exists(key:appKey2)){
  exit(0);
}

appPath  = registry_get_sz(key:appKey, item:"Install_Dir");
appPath2 = registry_get_sz(key:appKey2, item:"Install_Dir");

if(appPath != NULL)
{
   serenityVer = find_version(path:appPath, file:appPath +"\serenity.exe");
   if(serenityVer != NULL){
    set_kb_item(name:"Serenity/Audio/Player/Ver", value:serenityVer);
  }
}

if(appPath2 != NULL)
{
  mplayVer = find_version(path:appPath2, file:appPath2 + "\mplay.exe");
  if(mplayVer != NULL){
    set_kb_item(name:"Mplay/Audio/Player/Ver", value:mplayVer);
  }
}
