###############################################################################
# OpenVAS Vulnerability Test
#
# Solaris Update for kernel 127128-11
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(855192);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUNSolve", value: "127128-11");
  script_cve_id("CVE-2007-5135", "CVE-2006-3738", "CVE-2006-4343", "CVE-2006-4339", "CVE-2006-2937", "CVE-2006-2940", "CAN-2005-2969");
  script_name( "Solaris Update for kernel 127128-11");
  desc = "

  Vulnerability Insight:
  The remote host is missing a patch containing a security fix,
  which affects the following component(s): 
  kernel
  For more information please visit the below reference link.

  Affected Software/OS:
  kernel on solaris_5.10_x86

  Fix: Please Install the Updated Packages.

  References:
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-127128-11-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Solaris Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/solosversion");
  exit(0);
}


include("solaris.inc");

release = get_kb_item("ssh/login/solosversion");

if(release == NULL){
  exit(0);
}

if(solaris_check_patch(release:"5.10", arch:"i386", patch:"127128-11", package:"SUNWcpc.i SUNWrcmdc SUNWpsu SUNWfss SUNWatfsu SUNWscplp SUNWopenssl-include SUNWudapltu SUNWrds SUNWarc SUNWahci SUNWfmd SUNWintgige SUNWbtool SUNWperl584core SUNWypr SUNWcry SUNWkrbu SUNWsmapi SUNWtavor SUNWgssk SUNWpsdcr SUNWmdb SUNWzfsu SUNWaudit SUNWtsr SUNWpapi SUNWsndmu SUNWnfssu SUNWkdcu SUNWmdr SUNWpcr SUNWpsdir SUNWxcu4 SUNWudapltr SUNWdtrc SUNWopenssl-libraries SUNWcsl SUNWcpcu SUNWrcmds SUNWvolu SUNWib SUNWnisu SUNWos86r SUNWtoo SUNWcryr SUNWsi3124 SUNWtnetc SUNWtsg SUNWypu SUNWmv88sx SUNWftduu SUNWppm SUNWusb SUNWzfsr SUNWckr SUNWcsr SUNW1394 SUNWgss SUNWkrbr SUNWtsu SUNWmdbr SUNWlxr SUNWpcu SUNWzfskr SUNWarcr SUNWmdu SUNWpamsc SUNWnxge.i SUNWpsh SUNWhea SUNWcakr.i SUNWnfsckr SUNWdtrp SUNWspnego SUNWdcar SUNWpl5u SUNWnfsskr SUNWtnetd SUNWcslr SUNWippcore SUNWlxu SUNWcsu SUNWnfscu SUNWesu SUNWcsd SUNWpsr SUNWipplr SUNWpsm-lpd SUNWzoneu SUNWipplu SUNWnfscr SUNWftdur SUNWcstl") < 0)
{
  security_hole(0);
  exit(0);
}