###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_stardict_info_disc_vuln_lin.nasl 3194 3100 2009-07-07 17:38:29Z jul $
#
# StarDict Information Disclosure Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800644);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2260");
  script_name("StarDict Information Disclosure Vulnerability (Linux)");
  desc = "

  Overview: This host is installed with StarDict and is prone to Information
  Disclosure Vulnerability.

  Vulnerability Insight:
  Error exists when 'enable net dict' is configured, and it attempts to grab
  clipboard and sends it over network.

  Impact:
  Successful exploitation will let the attacker to gain sensitive information
  by sniffing the network.

  Impact Level: Application

  Affected Software/OS:
  StarDict version 3.0.1 on Linux

  Fix: No solution or patch is available as on 07th July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://stardict.sourceforge.net

  References:
  http://www.securityfocus.com/archive/1/504583
  https://bugzilla.redhat.com/show_bug.cgi?id=508945
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=534731

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 4.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of StarDict");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_stardict_detect_lin.nasl");
  script_require_keys("StarDict/Linux/Ver");
  exit(0);
}


include("version_func.inc");

stardictVer = get_kb_item("StarDict/Linux/Ver");
if(!stardictVer){
  exit(0);
}

if(stardictVer)
{
  # Check for StarDict version 3.0.1-4.1 (3.0.1)
  if(version_is_equal(version:stardictVer, test_version:"3.0.1")){
    security_warning(0);
  }
}
