###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_app_serv_xst_vuln.nasl 6970 2010-02-05 13:57:42Z feb $
#
# Sun Java System Application Server Cross Site Tracing Vulnerability
#
# Authors:
# Veerendra G <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800162);
  script_version("$Revision: 6681 $: 1.0");
  script_cve_id("CVE-2010-0386");
  script_name("Sun Java System Application Server Cross Site Tracing Vulnerability");
  desc = "
  Overview: This host has Sun Java System Application Server running which is
  prone to Cross Site Tracing vulnerability.

  Vulnerability Insight:
  An error exists while processing HTTP TRACE method and returns contents of
  clients HTTP requests in the entity-body of the TRACE response. An attacker
  can use this behavior to access sensitive information, such as cookies or
  authentication data, contained in the HTTP headers of the request.

  Impact:
  Successful exploitation lets the attackers to to get sensitive information,
  such as cookies or authentication data, contained in the HTTP headers.

  Impact Level: Application

  Affected Software/OS:
  Sun Java System Application Server Standard Edition 7 and later updates
  Sun Java System Application Server Standard Edition 7 2004Q2 and later updates

  Fix: No solution or patch is available,
  The workaround provided in the 'Workaround' section is the final resolution
  to this issue.

  Workaround:
  Apply the workaround as it is final resolution to this issue,
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-200942-1

  *****
  NOTE : Ignore this warning, if above workaround has been applied.
  *****

  References:
  http://www.kb.cert.org/vuls/id/867593
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-200942-1

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Sun Java Application Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_dependencies("secpod_sun_java_app_serv_detect.nasl");
  script_require_keys("Sun/Java/AppServer/Ver");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("http_func.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

## Get Sun Java Application Server version from KB
appservVer = get_kb_item("Sun/Java/AppServer/Ver");
if(appservVer =~ "^7" )
{
  ## Check for Sun Java Application Server version 7.0 and 7 2004Q2
  if(appservVer =~ "7.0|7 2004Q2"){
    security_warning(port);
  }
}
