###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_web_console_detect.nasl 3227 2009-07-08 13:57:35Z jul $
#
# Sun Java Web Console Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800825);
  script_version("Revision: 1.0 ");
  script_name("Sun Java Web Console Version Detection");
  desc = "

  Overview : This script detects the installed version of Java Web Console
  and sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set version of Sun Java Web Console in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  exit(0);
}


include("http_func.inc");
include("openvas-https.inc");

# Default HTTPS port
jwcPort = 6789;
if(!get_port_state(jwcPort)){
  exit(0);
}

# Send Request for Login page
sndReq1 = string("GET /console/faces/jsp/login/BeginLogin.jsp", " HTTP/1.1\r\n",
                 "Host: ", get_host_name(),":", jwcPort, "\r\n",
                 "User-Agent: Mozilla/5.0\r\n");
rcvRes1 = https_req_get(port:jwcPort, request:sndReq1);

# Check for Login Page with proper Response
if(rcvRes1 =~ "<title>Log In - Sun Java\(TM\) Web Console<" &&
   egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes1))
{
  # Grep the Version Page Path in Login Page
  jspPath = eregmatch(pattern:"versionWin = window.open\('([a-zA_Z0-9/_.]+)'",
                      string:rcvRes1);

  # Send Request for Version Page
  sndReq2 = string("GET ", jspPath[1], " HTTP/1.1\r\n",
                   "Host: ", get_host_name(), ":", jwcPort, "\r\n",
                   "User-Agent: Mozilla/5.0\r\n");
  rcvRes2 = https_req_get(port:jwcPort, request:sndReq2);

  # Check for Version Page with proper Response
  if(rcvRes2 =~ ">Display Product Version - Sun Java\(TM\) Web Console<" &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes2))
  {
    # Grep and Set KB for Java Web Console version
    jwcVer = eregmatch(pattern:">([0-9]\.[0-9.]+)<", string:rcvRes2);
    if(jwcVer[1] != NULL){
      set_kb_item(name:"Sun/JavaWebConsole/Ver", value:jwcVer[1]);
    }
  }
}
