###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_web_porxy_svr_vuln_lin.nasl 337 2008-10-16 13:17:21Z oct $
#
# Sun Java System Web Proxy Server Two Vulnerabilities (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800026);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4541");
  script_bugtraq_id(31691);
  script_name("Sun Java System Web Proxy Server Two Vulnerabilities (Linux)");
  desc = "
  Overview: This host has Sun Java Web Proxy Server running, which is prone
  to heap buffer overflow vulnerability.

  Vulnerability Insight:
  The flaw exist due to a boundary error in the FTP subsystem and in processing
  HTTP headers. This issue resides within the code responsible for handling HTTP
  GET requests.

  Impact:
  Successful exploitation could allow execution of arbitrary code in the context
  of the server, and failed attacks may cause denial-of-service condition.

  Impact Level: Application

  Affected Software/OS:
  Sun Java System Web Proxy Server versions prior to 4.0.8 on all running platform.

  Fix: Update to version 4.0.8 or apply patches.
  http://www.sun.com/software/products/web_proxy/get_it.jsp

  NOTE: Ignore this message if patch is applied already.

  References:
  http://secunia.com/advisories/32227
  http://xforce.iss.net/xforce/xfdb/45782
  http://www.frsirt.com/english/advisories/2008/2781
  http://web.nvd.nist.gov/view/vuln/detail?execution=e3s1
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-242986-1

  CVSS Score:
    CVSS Base Score     : 8.5 (AV:N/AC:M/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 6.3
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Sun Java Webproxy Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Buffer overflow");
  script_require_ports("Services/www", 8081);
  exit(0);
}


include("http_func.inc");
include("ssh_func.inc");
include("version_func.inc");

sunPort = get_http_port(default:8081);
if(!port){
  sunPort = 8081;
}

if(!get_port_state(sunPort)){
  exit(0);
}

banner = get_http_banner(port:sunPort);
if(!banner){
  exit(0);
}

if(banner =~ "Server: Sun-Java-System-Web-Proxy-Server/[0-3]\.0")
{
  security_hole(sunPort);
  exit(0);
}

if(banner =~ "Server: Sun-Java-System-Web-Proxy-Server/4\.0")
{
  sock = ssh_login_or_reuse_connection();
  if(!sock){
      exit(0);
  }

  sunName = find_file(file_name:"proxy-admserv/start", file_path:"/",
                      useregex:TRUE, regexpar:"$", sock:sock);
  foreach binary_sunName (sunName)
  {
    binary_name = chomp(binary_sunName);
    sunVer = get_bin_version(full_prog_name:binary_name, version_argv:"-version", sock:sock,
                             ver_pattern:"Web Proxy Server ([0-9.]+)");
    if(sunVer)
    { # Grep for versions prior to 4.0.8
      if(version_in_range(version:sunVer[1], test_version:"4.0", test_version2:"4.0.7")){
        security_hole(sunPort);
      }
      ssh_close_connection();
      exit(0);
    }
  }
 ssh_close_connection();
}
