###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_tdiary_detect.nasl 7519 2010-03-04 16:25:36Z mar $
#
# tDiary Version Detection
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800991);
  script_version("$Revision: 6941 $: 1.0");
  script_name("tDiary Version Detection");
  desc = "
  Overview: This script finds the installed version of tDiary and sets
  the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of tDiary in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

## Get HTTP Ports
diaryPort = get_http_port(default:80);
if(!diaryPort){
  diaryPort = 80;
}

## Check Port status
if(!get_port_state(diaryPort)){
  exit(0);
}

foreach path (make_list("/tdiary", "/", cgi_dirs()))
{
  ## Send the request and Recieve the response
  sndReq = http_get(item:string(path, "/index.rb"), port:diaryPort);
  rcvRes = http_send_recv(port:diaryPort, data:sndReq);

  ## Check tDiary in the response
  if(">tDiary<" >< rcvRes)
  {
    ## Match tDiary Version
    diaryVer = eregmatch(pattern:"tDiary.* version ([0-9.]+)<", string:rcvRes);
    if(diaryVer[1] != NULL)
    {
      set_kb_item(name:"www/" + diaryPort + "/tdiary",
                  value:diaryVer[1] + " under " + path);
      exit(0);
    }
  }
}
