###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_telepark_wiki_detect.nasl 5962 2009-12-12 16:25:36Z dec $
#
# Telepark.wiki Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801067);
  script_version("Revision: 1.0 ");
  script_name("Telepark.wiki Version Detection");
  desc = "
  Overview: This script finds the installed Telepark Wiki version and saves
  the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of Telepark Wiki in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

telwikiPort = get_http_port(default:80);
if(!telwikiPort){
  exit(0);
}

foreach path (make_list("/", "/teleparkwiki", "/twiki", cgi_dirs()))
{
  sndReq = http_get(item: path + "/index.php", port:telwikiPort);
  rcvRes = http_send_recv(port:telwikiPort, data:sndReq);
  if("telepark.wiki" >< rcvRes)
  {
    telwikiVer = eregmatch(pattern:">[vV]([0-9.]+)", string:rcvRes);
    if(telwikiVer[1] != NULL)
    {
      set_kb_item(name:"www/" + telwikiPort + "/Telepark.wiki",
                        value:telwikiVer[1] + " under " + path);
    }
  }
}
