###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_titan_ftp_detect.nasl 994 2009-02-09 12:40:24Z feb $
#
# Titan FTP Server Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800236);
  script_version("Revision: 1.0 ");
  script_name("Titan FTP Server Version Detection");
  desc = "
  Overview : This script detects the installed Titan FTP Server and saves the
  result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("General");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_summary("Set Version of Titan FTP Server in KB");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(!get_port_state(ftpPort)){
  exit(0);
}

banner = get_ftp_banner(port:ftpPort);
if("220 Titan FTP Server " >!< banner){
  exit(0);
}

titanVer = eregmatch(pattern:"Titan FTP Server ([0-9.]+)", string:banner);
if(titanVer[1] != NULL){
  set_kb_item(name:"TitanFTP/Server/Ver", value:titanVer[1]);
}
