###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_titan_ftp_server_bof_vuln.nasl 550 2008-12-01 18:36:29Z nov $
#
# Titan FTP Server DELE Command Remote Buffer Overflow Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800073);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5281", "CVE-2008-0702", "CVE-2008-0725");
  script_bugtraq_id(27611);
  script_name("Titan FTP Server DELE Command Remote Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is running Titan FTP Server and is prone to remote
  buffer overflow vulnerability.

  Vulnerability Insight:
  The flaw exists in server due to improper handling of input passed to the
  command DELE.

  Impact:
  Successful exploitation will allow remote attackers to deny the service.

  Affected Software/OS:
  Titan FTP Server version 6.05 build 550 and prior.

  Fix:
  Upgrade to the latest version,
  http://www.titanftp.com/download/index.html

  References:
  http://packetstormsecurity.org/0802-exploits/titan-heap-py.txt
  http://secunia.com/advisories/28760
  
  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Titan FTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(!get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port:port);
if("Titan FTP Server" >!< banner){
  exit(0);
}

ftpVer = eregmatch(pattern:"Titan FTP Server ([0-9.]+)", string:banner);
if(ftpVer[1] != NULL)
{
  # Grep for version <= 6.05.550
  if(version_is_less_equal(version:ftpVer[1], test_version:"6.05.550")){
    security_hole(port);
  }
}
