###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_tor_dns_spoofing_vuln_jul09_lin.nasl 3415 2009-07-16 21:50:29Z jul $
#
# Tor 'relay.c' DNS Spoofing Vulnerability - July09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800840);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2426");
  script_bugtraq_id(35505);
  script_name("Tor 'relay.c' DNS Spoofing Vulnerability - July09 (Linux)");
  desc = "

  Overview:
  This host is installed with Tor and is prone to DNS Spoofing vulnerability.

  Vulnerability Insight:
  Error in 'connection_edge_process_relay_cell_not_open' function in 'relay.c'
  in src/or/ allows exit relays to have an unspecified impact by causing
  controllers to accept DNS responses that redirect to an internal IP address
  via unknown vectors.

  Impact:
  Successful exploitation will let the attackers to conduct DNS spoofing
  attacks.

  Impact level: Application

  Affected Software/OS:
  Tor version 0.2.x before 0.2.0.35 and 0.1.x before 0.1.2.8-beta on Linux.

  Fix: Upgrade to version 0.2.0.35 or 0.1.2.8-beta or later
  http://www.torproject.org/download.html.en

  References:
  http://secunia.com/advisories/35546
  http://xforce.iss.net/xforce/xfdb/51377
  http://archives.seul.org/or/announce/Jun-2009/msg00000.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Tor");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_tor_detect_lin.nasl");
  script_require_keys("Tor/Linux/Ver");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

foreach torPort (make_list(9050, 9051, 8118))
{
  if(get_port_state(torPort))
  {
    sndReq = string("GET / HTTP/1.1", "\r\n",
                    "Host: ", get_host_name(), "\r\n\r\n");
    rcvRes = http_send_recv(port:torPort, data:sndReq);

    if(egrep(pattern:"<a\ href=?[^?]+:\/\/www\.torproject\.org",
             string:rcvRes) && "Tor" >< rcvRes)
    {
      torVer = get_kb_item("Tor/Linux/Ver");
      torVer = ereg_replace(pattern:"-", replace:".", string:torVer);
      if(torVer == NULL){
        exit(0);
      }

      # Check for Tor version 0.2 < 0.2.0.35 and 0.1 < 0.1.2.8-beta
      if(version_in_range(version:torVer, test_version:"0.1",
                                          test_version2:"0.1.2.8.alpha")||
         version_in_range(version:torVer, test_version:"0.2",
                                          test_version2:"0.2.0.34.alpha"))
      {
        security_warning(torPort);
        exit(0);
      }
    }
  }
}
