###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_torrent_trader_classic_detect.nasl 3077 2009-07-07 15:16:24Z jul $
#
# TorrentTrader Classic Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800525);
  script_version("Revision: 1.0 ");
  script_name("TorrentTrader Classic Version Detection");
  desc = "
  Overview: This script detects the installed version of TorrentTrader
  Classic and sets the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of TorrentTrader Classic");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

ttcPort = get_http_port(default:80);
if(!ttcPort){
  ttcPort = 80;
}
if(!get_port_state(ttcPort)){
  exit(0);
}

foreach dir (make_list("/ttc", "/", "/torrenttrader", "/torrent", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/upload/account-login.php"), port:ttcPort);
  rcvRes = http_send_recv(port:ttcPort, data:sndReq);
  if("TorrentTrader Classic" >< rcvRes){
    ttcVer = eregmatch(pattern:"Classic ([a-zA-z]+)? ?v([0-9.]+)", string:rcvRes);
    if(ttcVer[2] != NULL)
    {
      if(ttcVer[1] != NULL){
        ttcVer = ttcVer[2] + "." + ttcVer[1];
      }
      else
        ttcVer = ttcVer[2];
      set_kb_item(name:"www/"+ ttcPort + "/TorrentTraderClassic",
                    value:ttcVer + " under " + dir);
    }
  }
}
