##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_typsoft_ftp_detect.nasl 5967 2009-12-01 17:05:29Z dec $
#
# TYPSoft FTP Server Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(801057);
  script_version ("$Revision: 1.0 $");
  script_name("TYPSoft FTP Server Version Detection");
  desc = "
  Overview: This script determines the TYPSoft FTP server version on the remote host
  and sets the result in the KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Sets KB of TYPSoft FTP version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("FTP");
  script_dependencie("find_service.nes");
  script_require_ports("Services/www", 21);
  exit(0);
}


include("ftp_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(!get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port:port);
if("TYPSoft FTP" >< banner)
{
  tsVer = eregmatch(pattern:"TYPSoft FTP Server ([0-9.]+)", string:banner);
  if(tsVer[1] != NULL){
    set_kb_item(name:"TYPSoft/FTP/Ver", value:tsVer[1]);
  }
}
