###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for ekiga, gnomemeeting vulnerabilities USN-426-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840096);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "426-1");
  script_cve_id("CVE-2007-1006", "CVE-2007-1007");
  script_name( "Ubuntu Update for ekiga, gnomemeeting vulnerabilities USN-426-1");
  desc = "

  Vulnerability Insight:

  Mu Security discovered a format string vulnerability in Ekiga.  If a
  user was running Ekiga and listening for incoming calls, a remote
  attacker could send a crafted call request, and execute arbitrary code
  with the user's privileges.

  Affected Software/OS:
  ekiga, gnomemeeting vulnerabilities on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-February/000489.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ekiga, gnomemeeting vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"ekiga", ver:"2.0.1-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"ekiga", ver:"2.0.3-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"gnomemeeting", ver:"1.2.2-1ubuntu1.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}