###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for mozilla-thunderbird vulnerabilities USN-431-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840080);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "431-1");
  script_cve_id("CVE-2007-0008", "CVE-2007-0009", "CVE-2007-0775", "CVE-2007-0776", "CVE-2007-0777");
  script_name( "Ubuntu Update for mozilla-thunderbird vulnerabilities USN-431-1");
  desc = "

  Vulnerability Insight:

  The SSLv2 protocol support in the NSS library did not sufficiently
  check the validity of public keys presented with a SSL certificate. A
  malicious SSL web site using SSLv2 could potentially exploit this to
  execute arbitrary code with the user's privileges.  (CVE-2007-0008)
  
  The SSLv2 protocol support in the NSS library did not sufficiently
  verify the validity of client master keys presented in an SSL client
  certificate. A remote attacker could exploit this to execute arbitrary
  code in a server application that uses the NSS library.  (CVE-2007-0009)
  
  Various flaws have been reported that could allow an attacker to execute
  arbitrary code with user privileges by tricking the user into opening a
  malicious web page.  (CVE-2007-0775, CVE-2007-0776, CVE-2007-0777)

  Affected Software/OS:
  mozilla-thunderbird vulnerabilities on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-March/000496.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mozilla-thunderbird vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.10-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.10-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.10-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.10-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.10-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.10-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.10-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.10-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.10-0ubuntu0.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.10-0ubuntu0.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.10-0ubuntu0.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.10-0ubuntu0.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}