###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for evolution vulnerability USN-442-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840121);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "442-1");
  script_cve_id("CVE-2007-1002");
  script_name( "Ubuntu Update for evolution vulnerability USN-442-1");
  desc = "

  Vulnerability Insight:

  Ulf Harnhammar of Secunia Research discovered that Evolution did not
  correctly handle format strings when displaying shared memos.  If a
  remote attacker tricked a user into viewing a specially crafted shared
  memo, they could execute arbitrary code with user privileges.

  Affected Software/OS:
  evolution vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-March/000510.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of evolution vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"evolution-dbg", ver:"2.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-dev", ver:"2.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-plugins", ver:"2.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution", ver:"2.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"evolution-dbg", ver:"2.8.1-0ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-dev", ver:"2.8.1-0ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-plugins", ver:"2.8.1-0ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution", ver:"2.8.1-0ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}