###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for linux-source-2.6.15/2.6.17 vulnerabilities USN-451-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840066);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "451-1");
  script_cve_id("CVE-2007-0006", "CVE-2007-0772", "CVE-2007-0958");
  script_name( "Ubuntu Update for linux-source-2.6.15/2.6.17 vulnerabilities USN-451-1");
  desc = "

  Vulnerability Insight:

  The kernel key management code did not correctly handle key reuse.  A
  local attacker could create many key requests, leading to a denial of
  service. (CVE-2007-0006)
  
  The kernel NFS code did not correctly validate NFSACL2 ACCESS requests.
  If a system was serving NFS mounts, a remote attacker could send a
  specially crafted packet, leading to a denial of service.
  (CVE-2007-0772)
  
  When dumping core, the kernel did not correctly handle PT_INTERP
  processes.  A local attacker could create situations where they could
  read the contents of otherwise unreadable executable programs.
  (CVE-2007-0958)

  Affected Software/OS:
  linux-source-2.6.15/2.6.17 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-April/000519.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of linux-source-2.6.15/2.6.17 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28-386_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28-686_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28-k7_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28-server-bigiron_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28-server_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-28-386_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-28-686_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-28-k7_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-28-server-bigiron_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-28-server_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.15_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.15_2.6.15-28.53", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.17-11-386_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.17-11-generic_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.17-11-server-bigiron_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.17-11-server_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.17-11_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.17-11-386_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.17-11-generic_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.17-11-server-bigiron_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.17-11-server_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.17-11-386_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.17-11-generic_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.17-11-server-bigiron_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.17-11-server_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-kdump", ver:"2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.17_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.17_2.6.17.1-11.37", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}